% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_utilities.R
\name{cs2ic}
\alias{cs2ic}
\title{Convert current status data into interval censored format}
\usage{
cs2ic(time, eventOccurred)
}
\arguments{
\item{time}{Time of inspection}

\item{eventOccurred}{Indicator if event has occurred. 0/FALSE implies event has not occurred by inspection time.}
}
\description{
Convert current status data into interval censored format
}
\details{
Converts current status data to the interval censored format for 
usage in icenReg.
}
\examples{

simData <- simCS_weib()
# Simulate current status data

head(cs2ic(simData$time, simData$event))
# Converting data to current status format

fit <- ic_par(cs2ic(time, event) ~ x1 + x2, data = simData)
# Can be used directly in formula

}
