% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{decimal_to_short}
\alias{decimal_to_short}
\alias{decimal_to_short.icd9}
\alias{decimal_to_short.icd10}
\alias{decimal_to_short.icd10cm}
\alias{decimal_to_short.default}
\title{Convert Decimal format ICD codes to short format}
\usage{
decimal_to_short(x)

\method{decimal_to_short}{icd9}(x)

\method{decimal_to_short}{icd10}(x)

\method{decimal_to_short}{icd10cm}(x)

\method{decimal_to_short}{default}(x)
}
\arguments{
\item{x}{ICD codes}
}
\description{
This usually just entails removing the decimal point, but also does some
limited validation and tidying up. Missing leading zeroes will be added for
correctness of the shortened codes.
}
\section{Methods (by class)}{
\itemize{
\item \code{icd9}: convert ICD-9 codes from decimal to short
format

\item \code{icd10}: convert ICD-10 codes from decimal to short
format

\item \code{icd10cm}: convert ICD-10-CM codes from decimal to short
format

\item \code{default}: Guess ICD version and convert decimal to
short format
}}

\seealso{
Other ICD data conversion: 
\code{\link{comorbid_df_to_mat}()},
\code{\link{comorbid_mat_to_df}()},
\code{\link{convert}},
\code{\link{long_to_wide}()},
\code{\link{short_to_decimal}()},
\code{\link{wide_to_long}()}
}
\concept{ICD data conversion}
\keyword{internal}
\keyword{manip}
