% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condense.R, R/z-deprecated.R
\name{condense}
\alias{condense}
\alias{condense.character}
\alias{icd9_condense_decimal}
\alias{icd9_condense_short}
\alias{icd_condense.character}
\alias{icd_condense.icd9}
\alias{icd_condense}
\title{Condense ICD-9 code by replacing complete families with parent codes}
\usage{
condense(x, short_code = guess_short(x), defined = NULL, warn = TRUE, ...)

\method{condense}{character}(x, short_code = guess_short(x), defined = NULL,
  ...)

icd9_condense_decimal(x, defined = NULL, warn = TRUE,
  keep_factor_levels = FALSE)

icd9_condense_short(x, defined = NULL, warn = TRUE,
  keep_factor_levels = FALSE)

icd_condense.character(...)

icd_condense.icd9(...)

icd_condense(...)
}
\arguments{
\item{short_code}{single logical value which determines whether the ICD-9
code provided is in short (\code{TRUE}) or decimal (\code{FALSE}) form.
Where reasonable, this is guessed from the input data.}

\item{warn}{single logical value, if \code{TRUE}, give warnings when
there is discrepancy between \code{onlyReal} being \code{TRUE} yet data
containing undefined codes.}

\item{...}{arguments passed on to other functions}

\item{keep_factor_levels}{single logical value, default \code{FALSE}. If
\code{TRUE}, will reuse the factor levels from the input data for the
output data. This only applies if a factor is given for the input codes.}

\item{icd9}{is a character vector or factor of ICD-9 codes. If fewer than five characters
is given in a code, then the digits are greedily assigned to hundreds, then
tens, then units, before the decimal parts. E.g. "10" becomes "010", not
"0010".}

\item{icd9Short}{is a character vector of ICD-9 codes. If fewer than five characters is
given in a code, then the digits are greedily assigned to hundreds, then
tens, then units, before the decimal parts. E.g. "10" becomes "010", not
"0010"}

\item{icd9Decimal}{character vector of ICD-9 codes. If fewer than five characters is given in a
code, then the digits are greedily assigned to hundreds, then tens, then
units, before the decimal parts. E.g. "10" becomes "010", not "0010"}

\item{...}{arguments passed on to other functions}
}
\description{
These functions take a set of ICD codes, and look for parent ICD codes in the
hierarchy. If all the children of a parent are found, then the returned
vector will just contain the parents of those codes. Any additional codes
which did not have all the siblings present are retained. This can be thought
of as the inverse operation to \code{children}.
}
\section{Methods (by class)}{
\itemize{
\item \code{character}: Condense a set of ICD codes, guessing ICD version
from input data
}}

\section{Deprecated function names}{
 Future versions of \pkg{icd} will drop
  the \code{icd_} prefix. For example, \code{charlson} should be used in
  favor of \code{icd_charlson}. To distinguish \pkg{icd} function calls,
  consider using the namespace prefix \code{icd::} instead, e.g.,
  \code{icd::charlson}. Functions which specifically operate on either ICD-9
  or ICD-10 codes or their subtypes will retain the prefix. E.g.
  \code{\link{icd9_comorbid_ahrq}}. \pkg{icd} specific classes also retain
  the prefix, e.g., \code{\link{icd_wide_data}}.
}

\examples{
kids <- children("V40")
kids
condense(kids, defined = TRUE)
kids_with_undefined <- children("V40", defined = FALSE)
head(kids_with_undefined)
length(kids_with_undefined)
condense(kids, defined = FALSE)

# what happens if we have additional codes?
# (condense will warn if we don't explicitly ask to condense
# based on defined or possible codes.)
condense(c(kids, "41100"), warn = FALSE)

# a good use is to summarise the contents of a comorbidity:
icd9_map_elix$CHF
condense(icd9_map_elix$CHF, warn = FALSE)
# explaining big groups of codes takes advantage of this:
explain(icd9_map_elix$CHF, condense = TRUE, warn = FALSE)
}
\seealso{
Other ICD-9 ranges: \code{\link{children}},
  \code{\link{expand_minor}}, \code{\link{expand_range}}
}
\keyword{internal}
\keyword{manip}
