#' CD34+ count cell data
#'
#' A dataset containing CD34+ count cell data obtained by two methods
#'
#'
#' @format A data frame with 40 rows and 3 variables:
#' \describe{
#'   \item{y}{CD34+ counts}
#'   \item{id}{Subject}
#'   \item{met}{Method}
#' }
#' @references {
#' Fornas, O., Garcia, J., and Petriz, J. (2000). Flow cytometry counting of CD34+ cells in whole blood. Nature Medicine 6, 833–836.
#' }
"AF"

#' Sparrow fledglings paternity data
#'
#' A dataset containing the counts of fledglings a male had in every breeding season
#'
#' @format A data frame with 193 rows and 3 variables:
#' \describe{
#'   \item{Social}{Fledglings counts}
#'   \item{id}{Subject identifier}
#'   \item{Year}{Breeding season}
#' }
#' @references {
#' Schroeder, J., Burke, T., Mannarelli, M. E., Dawson, D. A., & Nakagawa, S. (2012). Maternal effects and heritability of annual productivity. Journal of Evolutionary Biology, 25, 149– 156.
#' }
"EPP"


#' Tick counts data
#'
#' A dataset containing the counts of ticks in Grimsö area
#'
#' @format A data frame with 520 rows and 3 variables:
#' \describe{
#'   \item{Tot}{Tick counts}
#'   \item{TransectID}{Subject identifier}
#'   \item{Round}{Replicate identifier}
#' }
#' @references {
#' Kjellander, P.L., Aronsson, M., Bergvall, U.A. et al. (2021). Validating a common tick survey method: cloth-dragging and line transects. Exp Appl Acarol 83, 131–146.
#' }
"Grimso"
