% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Item-Fit.R
\name{item_obsexp}
\alias{item_obsexp}
\title{Observed and Expected Item Mean Scores}
\usage{
item_obsexp(object)
}
\arguments{
\item{object}{An object of class "Rm", a fitted Rasch model or partial
credit model using  the functions RM or PCM in package eRm, or an object of class "pcmodel",
 a fitted partial credit model using the function pcmodel in package psychotools.}
}
\value{
list with observed and expected mean scores together with standardized residuals for the two score groups.
}
\description{
Homogeneity of item responses in the low and high score groups is analyzed by looking at observed and expected item mean scores
together with standardized residuals. If the Andersen's CLR test has shown some evidence against homogeneity,
this comparison can indicate which items might be responsible.
}
\examples{
rm.mod <- RM(amts[,4:13])
item_obsexp(rm.mod)
pc.mod <- PCM(desc2[,5:14])
item_obsexp(pc.mod)
}
\author{
Marianne Mueller
}
