% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SIplot.R
\name{SIplot}
\alias{SIplot}
\title{Plot Global Storm Activity Index WISA}
\usage{
SIplot(x, type = NULL, main = NULL, xlab = NULL, ylab = NULL,
  start = NULL, end = NULL, n.stations = NULL, ...)
}
\arguments{
\item{x}{estimation of WISA from \code{SAIndex}}

\item{type}{line width (default=1)}

\item{main, }{xlab, ylab graphical arguments, see \code{\link{par}}}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{start}{start date of records for magnetic activities.See examples.}

\item{end}{end date of records for magnetic activities.See examples}

\item{n.stations}{number of stations included in the study}

\item{...}{additional arguments}
}
\description{
Plot WISA, wavelet index of storm activity, by using ggplot2
}
\details{
This is an interface for visualizing WISA with ggplot2.
\code{SIplot} uses \code{as.POSIXct} to convert the index object into a data
frame with datetime. It essentially uses the mapping \code{geom_line} and adds
aes(x, y) to visualize the series.
}
\examples{
\dontrun{
## sample records for one week period
data(record)
coord=matrix(c(124.43, 19.23, 53.77,140.18,68.68,202.00,71.89,293.85),nrow=2,ncol=4)

index.sample<- SAIndex(record, coord, wf="la8")

## example dates
start.date="2001-3-1"
end.date="2001-4-30"
n.station=4
station.names=c("HER","KAK","HON","SJG")

## plot SI
SIplot(index.sample$SI, type=1, start=start.date, end=end.date, 
main="WISA estimation", xlab="Datetime", ylab="iWISA Estimation")
}
}
\seealso{
\code{\link{SAIndex}}, \code{\link{preindexplot}}
}

