% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_new_var.R
\name{createNewVar}
\alias{createNewVar}
\title{Create new variables}
\usage{
createNewVar(.data, new_var = "new.variable", R_exp)
}
\arguments{
\item{.data}{a dataframe to which to add a new variable to}

\item{new_var}{a character of the new variable name.
"new.variable" by default}

\item{R_exp}{a character of a valid R expression which can
generate a vector of values}
}
\value{
original dataframe containing the new column
        created from \code{R_exp}
with tidyverse code attached
}
\description{
Create a new variable by using a valid R expression
and returns the result along with tidyverse code used to generate it.
}
\examples{
created <- createNewVar(iris, new_var = "Sepal.Length_less_Sepal.Width",
 "Sepal.Length - Sepal.Width")
cat(code(created))
head(created)

}
\seealso{
\code{\link{code}}
}
\author{
Owen Jin
}
