% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iNZightQQplot.R
\name{iNZightQQplot}
\alias{iNZightQQplot}
\title{iNZight QQ Plot}
\usage{
iNZightQQplot(x, n = 5, env = parent.frame())
}
\arguments{
\item{x}{an \code{lm} or \code{svyglm} object (with \code{family = "Gaussian"}.}

\item{n}{the number of sampled QQ plots to produce beneath the QQ plot of
\code{x}.}

\item{env}{environment for finding data to bootstrap}
}
\value{
No return value, called to produce plot.
}
\description{
Produces a sample of QQ-plots based on the fitted values, overlaid by
a QQ-plot of the original data.
}
\details{
Multiple bootstrap models are generated from the fitted values of
the model, each with different random normal errors with standard
error equal to the estimated residual standard error from the
original model. These are plotted, and then overlaid by the QQ plot
from the original data.
\cr \cr
This plot can be used to assess the assumption of normality in the
residuals for a linear regression model.
}
\examples{
fit <- lm(Volume ~ Height + Girth, data = trees)
iNZightQQplot(fit)

}
\seealso{
\code{\link{histogramArray}}
}
\author{
David Banks, Tom Elliott
}
