% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F0034.R
\name{run.diff.exp}
\alias{run.diff.exp}
\title{Differential expression (DE) analysis}
\usage{
run.diff.exp(
  x = NULL,
  data.type = "main",
  de.by = "clusters",
  cond.1 = "array",
  cond.2 = "array",
  base.cond = 0
)
}
\arguments{
\item{x}{An object of class iCellR.}

\item{data.type}{Choose from "main" and "imputed", default = "main"}

\item{de.by}{Choose from "clusters", "conditions", "clustBase.condComp" or "condBase.clustComp".}

\item{cond.1}{First condition to do DE analysis on.}

\item{cond.2}{Second condition to do DE analysis on.}

\item{base.cond}{A base condition or cluster if de.by is either cond.clust or clust.cond}
}
\value{
An object of class iCellR
}
\description{
This function takes an object of class iCellR and performs differential expression (DE) analysis for clusters and conditions.
}
\examples{
diff.res <- run.diff.exp(demo.obj, de.by = "clusters", cond.1 = c(1), cond.2 = c(2))

head(diff.res)

}
