% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IARphigamma.R
\name{IAR.phi.gamma}
\alias{IAR.phi.gamma}
\title{Minus Log Likelihood IAR-Gamma Model}
\usage{
IAR.phi.gamma(x, y, sT)
}
\arguments{
\item{x}{An array with the parameters of the IAR-Gamma model. The first element of the array corresponding to the phi parameter, the second to the level parameter mu, and the last one to the scale parameter sigma.}

\item{y}{Array with the time series observations.}

\item{sT}{Array with the irregular observational times.}
}
\value{
Value of the negative log likelihood evaluated in phi, mu and sigma.
}
\description{
This function return the negative log likelihood of the IAR-Gamma given specific values of phi, mu and sigma.
}
\examples{
n=300
set.seed(6714)
st<-gentime(n)
y<-IARg.sample(n,phi=0.9,st,sigma2=1,mu=1)
IAR.phi.gamma(x=c(0.9,1,1),y=y$y,sT=st)
}
\references{
\insertRef{Eyheramendy_2018}{iAR}
}
\seealso{
\code{\link{gentime}}, \code{\link{IARg.sample}}
}
