% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypr.R
\name{filler_contrasts}
\alias{filler_contrasts}
\title{Generate filler contrasts}
\usage{
filler_contrasts(x, how.many = nlevels(x), rescale = TRUE)
}
\arguments{
\item{x}{A hypr object}

\item{how.many}{The total number of contrasts for the new hypr object}

\item{rescale}{If \code{TRUE}, the contrast weights will be rescaled}
}
\description{
Fill free degrees of freedom with orthogonal filler contrasts.
}
\examples{

# A complete Helmert contrast matrix for 4 levels:
h1 <- hypr(~ (mu2-mu1)/2,
          ~ (mu3-(mu1+mu2)/2)/3,
          ~ (mu4-(mu1+mu2+mu3)/3)/4,
          levels = c("mu1", "mu2", "mu3", "mu4")
          )
cmat(h1)

# An incomplete Helmer contrast matrix (2nd contrast dropped)
h2 <- hypr(~ (mu2-mu1)/2,
           ~ (mu4-(mu1+mu2+mu3)/3)/4,
           levels = c("mu1", "mu2", "mu3", "mu4")
           )
cmat(h2)

# Filling the remaining degree of freedom retrieves the contrast
h3 <- filler_contrasts(h2)
cmat(h3)

stopifnot(all.equal(cmat(h3)[,3], cmat(h1)[,2]))

}
