% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube.R
\docType{methods}
\name{show,Cube-method}
\alias{show,Cube-method}
\title{Shows a \code{Cube} object}
\usage{
\S4method{show}{Cube}(object)
}
\arguments{
\item{object}{The \code{Cube} object}
}
\description{
Shows the actual view of a \code{Cube} object. All added selections and aggregations will be
regarded. Note that selection criteria will be applied before the
aggregating the data.
}
\examples{

data("sales")
cube = generateCube(sales, columns = list(time = c("month", "year"),
      location = c("state"), product = "product"), valueColumn = "amount")
cube

}
\seealso{
\code{\link[=Cube-class]{Cube}}
}
\author{
Michael Scholz \email{michael.scholz@uni-passau.de}
}
