\name{powerboat}
\alias{powerboat}
\alias{powerboat_maxp}
\alias{powerboat2018}
\alias{powerboat_2018}
\alias{powerboat_table}
\docType{data}
\title{Powerboat dataset}
\description{Race results from the 2018 F1 Powerboat World Championship}
\usage{data(powerboat)}

\details{

  Object \code{powerboat_table} is a dataframe of results showing ranks
  of 21 drivers in the 2018 F1 Powerboat World Championship.  The format
  is standard, that is, can be interpreted by function
  \code{ordertable2supp()} and indeed
  \code{ordertable2supp(powerboat_table[,1:7])} gives the corresponding
  support function, \code{powerboat}.

  File \code{inst/powerboat.txt} is the source text file; to create
  \code{powerboat_table} use

  \code{read.table(system.file("powerboat.txt",package="hyper2"))}

  The dataset used here corrects an apparent typo in the wikipedia table
  (see github issue 37).

These objects can be generated by running script
\code{inst/powerboat.Rmd}, which includes some further discussion and
technical documentation and creates file \code{powerboat.rda} which
resides in the \code{data/} directory.
  
}
\references{

Wikipedia contributors. (2019, October 9). 2018 F1 Powerboat World
Championship. In \emph{Wikipedia, The Free Encyclopedia}.  Retrieved
00:45, February 21, 2020, from
\url{https://en.wikipedia.org/w/index.php?title=2018_F1_Powerboat_World_Championship&oldid=920386507}

}

\note{
  Many drivers have names with diacritics, which have been removed from
  the dataframe.
}
\seealso{\code{\link{ordertable2supp}}}
\examples{
data(powerboat)
jj <-
  read.table(system.file("powerboat.txt",package="hyper2"))
identical(jj,powerboat_table)  # should be TRUE
}


