# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

check_lag <- function(n, lag, n_shift) {
    .Call(`_hydrorecipes_check_lag`, n, lag, n_shift)
}

get_length <- function(n, n_subset) {
    .Call(`_hydrorecipes_get_length`, n, n_subset)
}

get_start <- function(n_out, lag, n_subset) {
    .Call(`_hydrorecipes_get_start`, n_out, lag, n_subset)
}

get_end <- function(n, n_out, lag, n_subset) {
    .Call(`_hydrorecipes_get_end`, n, n_out, lag, n_subset)
}

#' @title
#' shift_subset
#'
#' @description
#' lag data and subset the results
#'
#' @inheritParams step_lead_lag
#' @param x to lag (numeric vector)
#' @param lag amount to lag or lead if negative (integer)
#'
#' @return vector with lagged values
#'
#' @noRd
#'
shift_subset <- function(x, lag = 0L, n_subset = 1L, n_shift = 0L) {
    .Call(`_hydrorecipes_shift_subset`, x, lag, n_subset, n_shift)
}

#' @title
#' lag_matrix
#'
#' @description
#' lag data and subset the results
#'
#' @inheritParams step_lead_lag
#' @param x to lag (numeric vector)
#' @param lags lead or lag values (numeric vector)
#' @param var_name name for the generated matrix columns (character)
#'
#' @return matrix with lagged values
#'
#' @noRd
lag_matrix <- function(x, lags, n_subset = 1L, n_shift = 0L, var_name = "lead_lag") {
    .Call(`_hydrorecipes_lag_matrix`, x, lags, n_subset, n_shift, var_name)
}

#' @title
#' distributed_lag_parallel
#'
#' @description
#' This method calculates the basis for a distributed lag in parallel.  It is currently
#' slow.
#'
#' @inheritParams step_lead_lag
#' @param x values to lag (numeric vector)
#' @param bl the basis lags (numeric matrix)
#' @param lag_max maximum number of lags (integer)
#'
#' @return distributed lag basis
#'
#' @noRd
#'
distributed_lag_parallel <- function(x, bl, lag_max, n_subset = 1L, n_shift = 0L) {
    .Call(`_hydrorecipes_distributed_lag_parallel`, x, bl, lag_max, n_subset, n_shift)
}

