% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pumpcurve.R
\name{pumpcurve}
\alias{pumpcurve}
\title{Fits a polynomial curve to three or more points from a pump characteristic
curve. This allows solving for an operating point of the pump in a 
piping system.}
\usage{
pumpcurve(Q = NULL, h = NULL, eq = "poly1", units = c("SI", "Eng"))
}
\arguments{
\item{Q}{Numeric vector of flow rates for selected points on the pump curve [\eqn{m^3 s^{-1}}{m^3/s} or \eqn{ft^3 s^{-1}}{ft^3/s}]}

\item{h}{Numeric vector of heads for selected points on the pump curve [\eqn{m}{m} or \eqn{ft}{ft}]}

\item{eq}{Character vector identifying the for of equation to fit (see details)}

\item{units}{character vector that contains the system of units [options are
\code{SI} for International System of Units and \code{Eng} for English (US customary)
units.}
}
\value{
Returns an object of class \code{pumpcurve} consisting of a list including:
\itemize{
  \item curve - a function defining the curve that is fit to the data
  \item eqn - a character vector of the equation for the curve
  \item r2 - the coefficient of determination for the curve fit, \eqn{R^2}{R2}
  \item p - a plot object of the fit curve
  \item units - the units system passed to the function
}
}
\description{
A portion of this is based on
https://github.com/PhDMeiwp/basicTrendline/blob/master/R/trendline.R
}
\details{
The form of the equation fit to the input points may be one of the 
following, as determined by the \code{eq} input parameter.
\tabular{ll}{
  \strong{eq} \tab \strong{equation form} \cr
  poly1 \tab \eqn{h = a + {b}{Q} + {c}{Q}^2} \cr
  poly2 \tab \eqn{h = a + {c}{Q}^2} \cr
  poly3 \tab \eqn{h = h_{shutoff} + {c}{Q}^2}
  }
where \eqn{h_{shutoff}} is the head on the pump curve associated with 
\eqn{Q=0}. The shutoff head at \eqn{Q=0} should be included in the input
vectors if the \code{poly3} equation form is to be used.
}
\examples{

#Input in Eng units - use \code{units} package for easy unit conversion
qgpm <- units::set_units(c(0, 5000, 7850), gallons/minute)
qcfs <- units::set_units(qgpm, ft^3/s)
hft <- c(81, 60, 20) #units are already in ft so setting units is optional
pumpcurve(Q = qcfs, h = hft, eq = "poly2", units = "Eng")

}
\author{
Ed Maurer
}
