% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/water_properties.R
\name{waterprops}
\alias{waterprops}
\alias{dvisc}
\alias{dens}
\alias{kvisc}
\title{Functions to calculate water properties: density, dynamic and kinematic viscosity}
\usage{
dvisc(T = NULL, units = c("SI", "Eng"))

dens(T = NULL, units = c("SI", "Eng"))

kvisc(T = NULL, units = c("SI", "Eng"))
}
\arguments{
\item{T}{numeric vector that contains the water temperature [\eqn{^{\circ}C}{C} or \eqn{^{\circ}F}{F}]}

\item{units}{character vector that contains the system of units [options are
\code{SI} for International System of Units and \code{Eng} for English (US customary)
units. This is used for compatibility with iemisc package}
}
\value{
rho, the density of water for the
  dens function [\eqn{{kg}\,{m^{-3}}}{kg/m^3} or \eqn{{slug}\,{ft^{-3}}}{slug/ft^3}]

mu, the dynamic viscosity of water for the
  dvisc function [\eqn{{N}\,{s}\,{m^{-2}}}{N s/m^2} or \eqn{{lbf}\,{s}\,{ft^{-2}}}{lbf s/ft^2}]

nu, the kinematic viscosity of water for the
  kvisc function [\eqn{m^2 s^{-1}}{m^2/s} or \eqn{ft^2 s^{-1}}{ft^2/s}].
}
\description{
This function calculates water properties that are used in other functions.
}
\examples{

#Find kinematic viscocity for water temperature of 55 F
nu = kvisc(T = 55, units = 'Eng')

#Find kinematic viscocity assuming default water temperature of 68 F
nu = kvisc(units = 'Eng')

#Find water density for water temperature of 25 C
rho = dens(T = 25, units = 'SI')

}
\author{
Ed Maurer
}
