% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec_energy_trap.R
\name{spec_energy_trap}
\alias{spec_energy_trap}
\title{Creates a specific energy diagram for a trapezoidal channel}
\usage{
spec_energy_trap(
  Q = NULL,
  b = NULL,
  m = NULL,
  scale = 3,
  units = c("SI", "Eng")
)
}
\arguments{
\item{Q}{flow rate}

\item{b}{bottom width}

\item{m}{side slope (H:1)}

\item{scale}{multiplier (of yc) for plot scale (default is 3)}

\item{units}{character vector that contains the system of units [options are
\code{SI} for International System of Units and \code{Eng} for English (US customary)
units. This is used for compatibility with iemisc package]}
}
\value{
a specific energy diagram
}
\description{
This function plots a specific energy diagram of a trapezoidal
(including rectangle and triangle) channel, with annotation of
critical depth and minimum specific energy
}
\examples{

# Draw a specific cross-section with flow 1, width 2, side slope 3:1 (H:V)
spec_energy_trap(Q = 1.0, b = 2.0, m = 3.0, scale = 4, units = "SI")

}
\author{
Ed Maurer
}
