% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind-insert.R
\name{cbind.huxtable}
\alias{cbind.huxtable}
\alias{rbind.huxtable}
\title{Combine rows or columns}
\usage{
\method{cbind}{huxtable}(..., deparse.level = 1, copy_cell_props = TRUE)

\method{rbind}{huxtable}(..., deparse.level = 1, copy_cell_props = TRUE)
}
\arguments{
\item{...}{Vectors, matrices, or huxtables.}

\item{deparse.level}{Unused.}

\item{copy_cell_props}{Cell properties to copy from neighbours (see below).}
}
\value{
A huxtable.
}
\description{
These methods are called when one argument to \code{cbind}/\code{rbind} is a
huxtable. As well as combining cell contents, they copy table, row,
column and/or cell properties into the returned result.
}
\details{
Table properties will be taken from the first argument which is a huxtable. So will
row properties (for cbind) and column properties (for rbind).

If some of the inputs are not huxtables, and \code{copy_cell_props} is\code{TRUE},
then cell properties will be copied to non-huxtables. Objects on the left
or above get priority over those on the right or below.

If \code{copy_cell_props} is \code{FALSE}, cells from non-huxtable objects will get the default properties.

You cannot bind huxtables with data frames, since the R method dispatch will always
call the data frame method instead of the huxtable-specific code. For a solution, see
\code{\link[=add_columns]{add_columns()}}.
}
\examples{

sugar <- c("Sugar", "40\%", "35\%", "50\%")
jams <- set_bold(jams, 1, everywhere)
cbind(jams, sugar)
cbind(jams, sugar,
     copy_cell_props = FALSE)

jams <- set_text_color(jams,
     everywhere, 1, "red")
rbind(jams, c("Damson", 2.30))
rbind(jams, c("Damson", 2.30),
     copy_cell_props = FALSE)

}
