% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{font_size}
\alias{font_size}
\alias{font_size<-}
\alias{set_font_size}
\alias{map_font_size}
\title{Font size}
\usage{
font_size(ht)
font_size(ht) <- value
set_font_size(ht, row, col, value, byrow = FALSE)
map_font_size(ht, row, col, fn)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A numeric vector. This sets the font size in points.

Set to \code{NA} to reset to the default, which is \code{NA}.}

\item{row}{A row specifier. See \link{rowspecs} for details.}

\item{col}{An optional column specifier.}

\item{fn}{A mapping function. See \link{mapping-functions} for details.}

\item{byrow}{Deprecated. Use \code{\link[=by_cols]{by_cols()}} instead.}
}
\value{
For \code{font_size}, the \code{font_size} property.
For \code{set_font_size} and \code{map_font_size}, the modified huxtable.
}
\description{
Functions to get or set the \emph{font size} property of huxtable cells.
}
\examples{

orig <- font_size(jams)
font_size(jams) <-  14
font_size(jams)

font_size(jams) <- orig

jams2 <- set_font_size(jams,
      14)
font_size(jams2)

jams3 <- set_font_size(jams,
      2:3, 1, 14)
font_size(jams3)

jams4 <- map_font_size(jams,
      by_rows(
        14,
        12)
      )
font_size(jams4)
}
\seealso{
Other formatting functions: \code{\link{background_color}},
  \code{\link{bold}}, \code{\link{font}},
  \code{\link{na_string}}, \code{\link{number_format}},
  \code{\link{text_color}}
}
\concept{formatting functions}
