% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{background_color}
\alias{background_color}
\alias{background_color<-}
\alias{set_background_color}
\alias{map_background_color}
\title{Background color}
\usage{
background_color(ht)
background_color(ht) <- value
set_background_color(ht, row, col, value, byrow = FALSE)
map_background_color(ht, row, col, fn)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A character vector or matrix of valid R color names.

Set to \code{NA} to reset to the default, which is \code{NA}.}

\item{row}{A row specifier. See \link{rowspecs} for details.}

\item{col}{An optional column specifier.}

\item{fn}{A mapping function. See \link{mapping-functions} for details.}

\item{byrow}{Deprecated. Use \code{\link[=by_cols]{by_cols()}} instead.}
}
\value{
For \code{background_color}, the \code{background_color} property.
For \code{set_background_color} and \code{map_background_color}, the modified huxtable.
}
\description{
Functions to get or set the \emph{background color} property of huxtable cells.
}
\examples{

orig <- background_color(jams)
background_color(jams) <-  grey(.95)
background_color(jams)

background_color(jams) <- orig

set_background_color(jams, grey(.95))
set_background_color(jams,
      2:3, 1, grey(.95))
map_background_color(jams,
      by_rows(grey(.95), "yellow"))
}
\seealso{
Other formatting functions: \code{\link{bold}},
  \code{\link{font_size}}, \code{\link{font}},
  \code{\link{na_string}}, \code{\link{number_format}},
  \code{\link{text_color}}
}
\concept{formatting functions}
