% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{quick-output}
\alias{quick-output}
\alias{quick_pdf}
\alias{quick_html}
\alias{quick_docx}
\title{Quickly create a PDF, HTML or Word document showing matrices, data frames, et cetera.}
\usage{
quick_pdf(..., file = "huxtable-output.pdf", borders = 0.4)

quick_html(..., file = "huxtable-output.html", borders = 0.4)

quick_docx(..., file = "huxtable-output.docx", borders = 0.4)
}
\arguments{
\item{...}{One or more huxtables or R objects with an \code{as_huxtable} method.}

\item{file}{File path for the output.}

\item{borders}{Border width for members of \code{...} that are not huxtables.}
}
\value{
Invisible \code{NULL}.
}
\description{
Quickly create a PDF, HTML or Word document showing matrices, data frames, et cetera.
}
\details{
Objects in \code{...} will be converted to huxtables, with borders added.
}
\examples{
\dontrun{
m <- matrix(1:4, 2, 2)
dfr <- data.frame(a = 1:5, b = 1:5)
quick_pdf(m, dfr)
quick_html(m, dfr)
quick_docx(m, dfr)
}
}
