% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{Pos}
\alias{Pos}
\title{Find the chromosome position for SNP ids, gene name or band}
\usage{
Pos(ids, dir = NULL, snps.only = FALSE)
}
\arguments{
\item{ids}{character, a vector of rs-ids or chip-ids representing SNPs in the current ChipInfo 
annotation,or gene ids, or karyotype bands. Can also be a SnpMatrix object.}

\item{dir}{character, only relevant when gene or band ids are entered, in this case 'dir' is 
the location to download gene and cytoband information; if left as NULL, depending on the 
value of getOption("save.annot.in.current"), the annotation will either be saved in the 
working directory to speed-up subsequent lookups, or deleted after use.}

\item{snps.only}{logical, if TRUE, only search SNP ids, ignore the possibility of 
genes/cytobands.}
}
\value{
When ids are SNP ids, returns a numeric vector of positions for each id, with NA 
values where no result was found. When ids are genes or karyotype bands, will return a 
data.frame with columns 'chr' [chromosome], 'start' [starting position of feature], 'end'
[end position of feature], and the band without the chromosome prefix, if ids are bands. 
Note that this function cannot retrieve multiple ranges for a single gene (e.g, OR2A1 in
build 38), which means you'd need to use Pos.gene(). The coordinates used will be of 
version getOption(ucsc="hg18"), or ucsc(chip.support()), which should be equivalent.
}
\description{
Allows retrieval of the the chromosome position associated with a SNP-id, HGNC gene label, 
 karyotype band, or vector of such ids. For SNPs the ids can be either chip ids, or rs-ids,
 but must be contained in the current annotation. Default behaviour is to assume 'id' are 
 SNP ids, but if none are found in the SNP annotation, the id's will be passed to functions
 Pos.gene() and Pos.band() to see whether a result is found. This latter step will only happen
 if no SNP ids are retreived in the first instance, and if snps.only=TRUE, then genes and bands
 will not be searched and NA's returned. If you are repeatedly searching for positions for 
 genes/bands, using the dedicated Pos.gene() and Pos.band() functions would be slightly faster
 than relying on the fallback behaviour of the Pos() function. Note that the position for
 genes and bands are not a single point, so the result will be a range with start and end, 
 see 'values' below. See documentation for these functions for more information.
}
\examples{
\donttest{
setwd(tempdir())
Pos(c("rs689","rs9467354","rs61733845"))
Pos("CTLA4") # returns a range
Pos("13q21.31") # returns a range
Pos(c("CTLA4","PTPN22"),snps.only=TRUE) # fails as these are genes
Pos(c("rs689","PTPN22","13q21.31")) # mixed input, will default to SNPs, as at least 1 was found
}
}
\seealso{
\code{\link{Chr}}
}
\author{
Nicholas Cooper \email{nick.cooper@cimr.cam.ac.uk}
}
