% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mock-api.R
\name{with_mock_api}
\alias{with_mock_api}
\alias{with_mock_API}
\title{Serve a mock API from files}
\usage{
with_mock_api(expr)

with_mock_API(expr)
}
\arguments{
\item{expr}{Code to run inside the fake context}
}
\value{
The result of \code{expr}
}
\description{
In this context, HTTP requests attempt to load API response fixtures from
files. This allows test code to proceed evaluating code that expects
HTTP requests to return meaningful responses. Requests that do not have a
corresponding fixture file raise errors, like how \code{\link[=without_internet]{without_internet()}}
does.
}
\details{
Requests are translated to mock file paths according to several rules that
incorporate the request method, URL, query parameters, and body. See
\code{\link[=build_mock_url]{build_mock_url()}} for details.

File paths for API fixture files may be relative to the 'tests/testthat'
directory, i.e. relative to the .R test files themselves. This is the default
location for storing and retrieving mocks, but you can put them anywhere you
want as long as you set the appropriate location with \code{\link[=.mockPaths]{.mockPaths()}}.

\code{with_mock_API()} is a deprecated alias for \code{with_mock_api()} and will be
removed in the next release.
}
\seealso{
\code{\link[=use_mock_api]{use_mock_api()}} to enable mocking on its own (not in a context); \code{\link[=build_mock_url]{build_mock_url()}}; \code{\link[=.mockPaths]{.mockPaths()}}
}
