% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/offline.R
\name{skip_if_disconnected}
\alias{skip_if_disconnected}
\title{Skip tests that need an internet connection if you don't have one}
\usage{
skip_if_disconnected(message = paste("Offline: cannot reach", url),
  url = "http://httpbin.org/")
}
\arguments{
\item{message}{character message to be printed, passed to
\code{\link[testthat]{skip}}}

\item{url}{character URL to ping to check for a working connection}
}
\value{
If offline, a test skip; else invisibly returns TRUE.
}
\description{
Temporary connection trouble shouldn't fail your build.
}
\details{
Note that if you call this from inside one of the mock contexts, it will
follow the mock's behavior. That is, inside \code{\link{with_fake_HTTP}},
the check will pass and the following tests will run, but inside
\code{\link{without_internet}}, the following tests will be skipped.
}
\seealso{
\code{\link[testthat]{skip}}
}

