% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{honda2023.qspr}
\alias{honda2023.qspr}
\title{Predicted Caco-2 Apical-Basal Permeabilities}
\format{
An object of class \code{data.frame} with 14033 rows and 5 columns.
}
\usage{
honda2023.qspr
}
\description{
Honda et al. (2023) describes the construction of a machine-learning 
quantitative structure-property relationship (QSPR )model for in vitro Caco-2 
membrane permeabilites. That model was used to make chemical-specific 
predictions provided in this table.
}
\details{
\tabular{lll}{
\strong{Column Name} \tab \strong{Description} \tab \strong{Units} \cr
DTXSID \tab EPA's DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard}) \tab \cr
Pab.Class.Pred \tab Predicted Pab rate of slow (1), moderate (2), or fast (3) \tab \cr
Pab.Pred.AD \tab Whether (1) or not (0) the chemical is anticipated to be withing the QSPR domain of applicability \tab \cr
CAS \tab Chemical Abstracts Service Registry Number \tab \cr
Pab.Quant.Pred \tab Median and 95-percent interval for values within the predicted class's training data  moderate (2), or fast (3) \tab 10^-6 cm/s \cr
}
}
\references{
\insertRef{HondaUnpublishedCaco2}{httk}
}
\seealso{
\code{\link{load_honda2023}}
}
\keyword{datasets}
