% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htmlTable_helpers.R
\name{prPrepareAlign}
\alias{prPrepareAlign}
\title{Prepares the align to match the columns}
\usage{
prPrepareAlign(align, x, rnames, default_rn = "l")
}
\arguments{
\item{align}{A character strings specifying column alignments, defaulting to
\code{\link[base]{paste}(rep('c',ncol(x)),collapse='')} to center. Valid alignments are
l = left, c = center and r = right. You can also specify \code{align='c|c'} and
other LaTeX tabular formatting. If you want to set the alignment of the
rownames this string needst to be \code{ncol(x) + 1}, otherwise it automatically
pads the string with a left alignment for the rownames.}

\item{x}{The matrix/data.frame with the data. For the \code{print} and \code{knit_print}
it takes a string of the class \code{htmlTable} as \code{x} argument.}

\item{rnames}{Default rownames are generated from \code{\link[base]{rownames}(x)}. If you
provide \code{FALSE} then it will skip the rownames. \emph{Note:} For \code{data.frames}
if you do \code{\link[base]{rownames}(my_dataframe) <- NULL} it still has
rownames. Thus you need to use \code{FALSE} if you want to
surpress rownames for \code{data.frames}.}

\item{default_rn}{The default rowname alignment. This is an option
as the header uses the same function and there may be differences in
how the alignments should be implemented.}
}
\description{
The alignment may be tricky and this function therefore simplifies
this process by extending/shortening the alignment to match the
correct number of columns.
}
\seealso{
Other hidden helper functions for \code{\link{htmlTable}}: \code{\link{prAddCells}},
  \code{\link{prAddSemicolon2StrEnd}},
  \code{\link{prGetCgroupHeader}},
  \code{\link{prGetRowlabelPos}}, \code{\link{prGetStyle}},
  \code{\link{prPrepareCgroup}}, \code{\link{prTblNo}}
}
\keyword{internal}

