% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icstestClust.R
\name{icstestClust}
\alias{icstestClust}
\title{Test for Informative Cluster Size}
\usage{
icstestClust(x, id, test.method = c("TF", "TCM"), B = 1000, print.it = TRUE)
}
\arguments{
\item{x}{a vector of numeric responses. Can also be a data frame.}

\item{id}{a vector or factor object which identifies the clusters; ignored if \code{x} is a data frame.
The length of \code{id} must be the same as the length of \code{x}.}

\item{test.method}{character string specifying the method of construction for the test statistic.
Must be one of "\code{TF}" or "\code{TCM}".}

\item{B}{the number of bootstrap iterations.}

\item{print.it}{a logical indicating whether to print the progression of bootstrap iterations.}
}
\value{
A list with class "\code{htest}" containing the following components:
\item{statistic}{the value of the test statistic.}
\item{p.value}{the p-value of the test.}
\item{method}{a character string indicating the test performed and the method of construction.}
\item{data.name}{a character string giving the name(s) of the data.}
}
\description{
Performs a test for informative cluster size.
}
\details{
The null is that the marginal distributions of the responses are independent of the cluster sizes.
A small p-value is evidence for the presence of informative cluster size.

When \code{test.method = "TF"}, the test statistic is constructed based on differences between the null and
alternative distribution functions. "\code{TF}" is the suggested method when there are a large
number of unique cluster sizes and the number of clusters of each size is small. When \code{test.method = "TCM"},
the test statistic is a multisample Cramer von Mises-based test. This method is recommended
when there are a small number of possible cluster sizes. See Nevalainen \emph{et al.} (2017) for more details.

When \code{x} is a data frame, the first column should contain values denoting cluster membership and
the second column the responses.

This test is computationally intensive and can take significant time to execute. \code{print.it} defaults to
\code{TRUE} to identify the bootstrap progression.
}
\examples{
\donttest{
  data(screen8)
  ## using vectors
  ## test if cluster size is related to math scores
  icstestClust(screen8$math, screen8$sch.id, B=100)

  ## same test, but using a data frame and supressing iterations
  tdat <- data.frame(screen8$sch.id, screen8$math)
  icstestClust(tdat, B=100, print.it = FALSE)
}
}
\references{
Nevalainen, J., Oja, H., Datta, S. (2017) Tests for informative cluster size using a novel balanced bootstrap scheme.
\emph{Statistics in Medicine}, \bold{36}, 2630--2640.
}
