% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{startvalue}
\alias{startvalue}
\title{Start value for maternal allele and haplotype frequencies}
\usage{
startvalue(Fam1, Fam2, Dd = 0, prec = 1e-06)
}
\arguments{
\item{Fam1}{matrix (DIM n.progeny x 2) of progeny genotypes of genomic family
with coupling phase sires (1) at SNP pair}

\item{Fam2}{matrix (DIM n.progeny x 2) of progeny genotypes of genomic family
with repulsion phase sires (2) at SNP pair}

\item{Dd}{maternal LD, default 0}

\item{prec}{minimum accepted start value for fAA, fAB, fBA; default
\code{1e-6}}
}
\value{
list (LEN 8)
\describe{
 \item{\code{fAA.start}}{frequency of maternal haplotype 1-1}
 \item{\code{fAB.start}}{frequency of maternal haplotype 1-0}
 \item{\code{fBA.start}}{frequency of maternal haplotype 0-1}
 \item{\code{p1}}{estimate of maternal allele frequency (allele 1) when sire
  is heterozygous at \code{SNP1}}
 \item{\code{p2}}{estimate of maternal allele frequency (allele 1) when sire
  is heterozygous at \code{SNP2}}
 \item{\code{L1}}{lower bound of maternal LD}
 \item{\code{L2}}{upper bound for maternal LD}
 \item{\code{critical}}{0 if parameter estimates are unique; 1 if parameter
  estimates at both solutions are valid}
}
}
\description{
Determine default start values for Expectation Maximisation (EM)
 algorithm that is used to estimate paternal recombination rate and maternal
 haplotype frequencies
}
\examples{
 n1 <- 100
 n2 <- 20
 G1 <- matrix(ncol = 2, nrow = n1, sample(c(0:2), replace = TRUE,
  size = 2 * n1))
 G2 <- matrix(ncol = 2, nrow = n2, sample(c(0:2), replace = TRUE,
  size = 2 * n2))
 startvalue(G1, G2)
}
