\name{hh}
\alias{hh}
\title{
Heatmap of Half-sibs
}
\description{
The hh function creates a heatmap of the half-sib families using the
matrix of opposing homozygotes.}
\usage{
	hh(oh, inferredPedigree, realPedigree, pedOnly = TRUE)
}
		\arguments{
			\item{oh}{
				\code{matrix} Opposing homozygotes matrix (output of \code{ohg})
			}
			\item{inferredPedigree}{\code{matrix}
				inferred pedigree (output of \code{rpoh})
			}
			\item{realPedigree}{\code{matrix}
				original pedigree
			}
        \item{pedOnly}{\code{logical}
				Consider only individuals that are exist in the real pedigree 
			}
		}

\value{
	Returns the heatmap of the matrix of opposing homozygotes with sidebars colour coded by sires from the inferred and original pedigree.
}
\author{
 The fuction uses the colour generated by \emph{getcol} function in the \emph{made4} package (Aedin Culhane).
 
}
		
\seealso{
	\code{\link{ohg}} and \code{\link{rpoh}}
}
\examples{
c1h1 <- .simulateHalfsib(numInd = 62,numSNP = 5000)
c1h2 <- .simulateHalfsib(numInd = 38,numSNP = 5000)
Genotype <- rbind(c1h1,c1h2)
oh <- ohg(Genotype) # creating the Opposing Homozygote matrix
hh(oh)
}
\keyword{heatmap}
\keyword{pedigree}