% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcForecastError.R
\name{calcForecastError}
\alias{calcForecastError}
\title{Calculate the forecast accuracy of series of indexes}
\usage{
calcForecastError(is_obj, pred_df, return_forecasts = FALSE,
  forecast_length = 1, ...)
}
\arguments{
\item{is_obj}{Object of class 'hpiseries'}

\item{pred_df}{Set of sales to be used for predictive quality of index}

\item{return_forecasts}{default = FALSE; return the forecasted indexes}

\item{forecast_length}{default = 1; Length of period(s) in time to forecast}

\item{...}{Additional Arguments}
}
\value{
object of class `hpiaccuracy` inheriting from class `data.frame` containing
the following fields:
\describe{
  \item{prop_id}{Property Identification number}
  \item{price}{Transaction Price}
  \item{pred_price}{Predicted price}
  \item{error}{(Prediction - Actual) / Actual}
  \item{log_error}{log(prediction) - log(actual)}
  \item{pred_period}{Period of the prediction}
  \item{series}{Series position from which the prediction was generated}
}
}
\description{
Estimate the index accuracy with forecasting for a (progressive) series of indexes
}
\section{Further Details}{

If you set `return_forecasts` = TRUE, the forecasted indexes for each period will be
returned in the `forecasts` attribute of the `hpiaccuracy` object. (attr(accr_obj,
'forecasts')

For now, the `pred_df` object must be a set of repeat transactions with the class `rt`,
inheriting from `hpidata`
}

\examples{

 # Load example sales
 data(ex_sales)

 # Create Index
 hed_index <- hedIndex(trans_df = ex_sales,
                       periodicity = 'monthly',
                       max_date = '2011-12-31',
                       adj_type = 'clip',
                       date = 'sale_date',
                       price = 'sale_price',
                       trans_id = 'sale_id',
                       prop_id = 'pinx',
                       estimator = 'robust',
                       log_dep = TRUE,
                       trim_model = TRUE,
                       max_period = 24,
                       dep_var = 'price',
                       ind_var = c('tot_sf', 'beds', 'baths'),
                       smooth = FALSE)

 # Create Series (Suppressing messages do to small sample size of this example)
  suppressMessages(
    hpi_series <- createSeries(hpi_obj = hed_index,
                               train_period = 12))

 # Create Prediction data
 rt_data <- rtCreateTrans(trans_df = ex_sales,
                          prop_id = 'pinx',
                          max_date = '2011-12-31',
                          trans_id = 'sale_id',
                          price = 'sale_price',
                          periodicity = 'monthly',
                          date = 'sale_date',
                          min_period_dist = 12)


 # Calculate forecast accuracty
 fc_accr <- calcForecastError(is_obj = hpi_series,
                              pred_df = rt_data)

}
