% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hedCreateTrans.R
\name{hedCreateTrans}
\alias{hedCreateTrans}
\title{Create data for `hed` approach}
\usage{
hedCreateTrans(trans_df, prop_id, trans_id, price, date = NULL,
  periodicity = NULL, ...)
}
\arguments{
\item{trans_df}{sales transaction in either a data.frame or a
trans_df class from dateToPeriod() function}

\item{prop_id}{field contain the unique property identification}

\item{trans_id}{field containing the unique transaction identification}

\item{price}{field containing the transaction price}

\item{date}{default=NULL, field containing the date of the transaction.
Only necessary if not passing an `hpidata` object}

\item{periodicity}{default=NULL, field containing the desired periodicity of analysis.
Only necessary if not passing a `hpidata` object}

\item{...}{Additional arguments}
}
\value{
data.frame of transactions with standardized period field. Note that a full
data.frame of the possible periods, their values and names can be found in the
attributes to the returned `hed` object
}
\description{
Generate standardized data for the `hed` modeling approach
}
\examples{

 # Load example data
 data(ex_sales)

 # Create Hed Data
 ex_heddata <- hedCreateTrans(trans_df = ex_sales,
                              prop_id = 'pinx',
                              trans_id = 'sale_id',
                              price = 'sale_price',
                              date = 'sale_date',
                              periodicity = 'monthly')

}
