% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcForecastError.R
\name{buildForecastIDs}
\alias{buildForecastIDs}
\title{Create the row IDs for forecast accuracy}
\usage{
buildForecastIDs(time_cut, hpi_df, forecast_length = 1, train = TRUE)
}
\arguments{
\item{time_cut}{Period after which to cut off data}

\item{hpi_df}{Data to be converted to training or scoring}

\item{forecast_length}{default = 1; Length of forecasting to do}

\item{train}{Default=TRUE; Create training data?  FALSE = Scoring data}

\item{...}{Additional Arguments}
}
\value{
vector of row_ids indicating inclusion in the forecasting data as either the
training set (train = TRUE) or the scoring set (train = FALSE)
}
\description{
Generate a vector of row IDs for use in forecast accuracy tests
}
\section{Further Details}{

This function is rarely (if ever) used directly.  Most often called by
`calcForecastError()`

It is a generic method that dispatches on the `hpi_df` object.
}

\examples{

  # Load example sales
 data(ex_sales)

 # Create RT data
 rt_data <- rtCreateTrans(trans_df = ex_sales,
                          prop_id = 'pinx',
                          trans_id = 'sale_id',
                          price = 'sale_price',
                          periodicity = 'monthly',
                          date = 'sale_date')

# Create ids
  fc_ids <- buildForecastIDs(time_cut = 27,
                             hpi_df = rt_data,
                             forecast_length = 2,
                             train = TRUE)

}
