% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\name{group_inout}
\alias{group_inout}
\title{In-Out Constraint}
\usage{
group_inout(vars)
}
\arguments{
\item{vars}{a vector specifying the indices or names of the covariates to which the constraint shall be applied.}
}
\value{
A holistic generalized model constraint, object inheriting from class \code{"hglmc"}.
}
\description{
Forces coefficients of the covariates in the specified group to be either all zero or all nonzero.
}
\examples{
dat <- rhglm(100, c(1, 2, 3, 4, 5, 6))
constraints <- group_inout(c("x1", "x2", "x3"))
hglm(y ~ ., constraints = constraints, data = dat)
}
\seealso{
Other Constraint-Constructors: 
\code{\link{group_equal}()},
\code{\link{group_sparsity}()},
\code{\link{include}()},
\code{\link{k_max}()},
\code{\link{linear}()},
\code{\link{lower}()},
\code{\link{pairwise_sign_coherence}()},
\code{\link{rho_max}()},
\code{\link{sign_coherence}()},
\code{\link{upper}()}
}
\concept{Constraint-Constructors}
