% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{agg_binomial}
\alias{agg_binomial}
\title{Aggregate Binomial Data}
\usage{
agg_binomial(formula, data, as_list = TRUE)
}
\arguments{
\item{formula}{a formula object defining the aggregation.}

\item{data}{a \code{data.frame} to be aggregated.}

\item{as_list}{a logical giving if the return value
should be a \code{list}. If \code{FALSE} the return value
is a \code{data.frame}.}
}
\value{
A \code{list} (or \code{data.frame}) containing aggregated
 binomial data with counted successes and failures.
}
\description{
A simple function for aggregating binomial data, from
a form where \code{y} contains only \code{0} and \code{1}
and \code{X} could contain duplicated rows, into a format where
\code{y} is the matrix of counted successes and failures
and \code{X} does not contain duplicates. If \code{X} contains
factor variables, the model matrix corresponding to \code{X}
will be returned.
}
\examples{
set.seed(12345)
data <- data.frame(y = rbinom(50, 1, 0.7),
                   a = factor(sample(c(1, 2), 50, TRUE)),
                   b = factor(sample(c(1, 2, 3), 50, TRUE)))
agg_binomial(y ~ ., data)
}
