% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmi_smallfunctions_2018-05-07.R
\name{negloglik}
\alias{negloglik}
\title{calculate the likelihood contribution of the data}
\usage{
negloglik(para, parnames = names(para), X_in_negloglik, PSI_in_negloglik,
  y_precise_stand, lower_bounds = NA, upper_bounds = NA, my_g,
  sd_of_y_precise, indicator_precise, indicator_imprecise, indicator_outliers,
  rounding_degrees = c(1, 10, 100, 1000))
}
\arguments{
\item{para}{This is the vector \eqn{Psi} of parameters
(see p. 62 in Drechsler, Kiesl & Speidel, 2015).
With respect to them, the value returned by negloglik shall be
maximized.\cr
The starting values are c(kstart, betastart, gamma1start, sigmastart)
(the thresholds (or "cutting points") for the latent variable behind the rounding degree,
the regression parameters explaining the logged income,
the regression parameters explaining the rounding degree
and the variance parameter).}

\item{parnames}{A character vector with the names of the elements in para.}

\item{X_in_negloglik}{The data.frame of covariates explaining Y, the observed target variable.
It has to has n rows (with n being the number of precise, imprecise and missing observations).}

\item{PSI_in_negloglik}{The data.frame of covariates explaining G, the latent rounding tendency.
Without the target variable.}

\item{y_precise_stand}{A vector of the precise (and standardized) observations from the target variable.}

\item{lower_bounds}{The lower bounds of an interval variable.}

\item{upper_bounds}{The upper bounds of an interval variable.}

\item{my_g}{This vector is the indicator of the (highest possible) rounding degree for an observation.
This parameter comes directly from the data.}

\item{sd_of_y_precise}{The scalar with the value equal to the standard deviation of the target variable.}

\item{indicator_precise}{A boolean Vector indicating whether the value in the original target
variable is precise (e.g. 5123 or 5123.643634) or not.}

\item{indicator_imprecise}{A boolean Vector indicating whether the value in the original target
variable is imprecise (e.g. "5120;5130) or not.}

\item{indicator_outliers}{A boolean Vector indicating whether the value in the precise
observations of the original target are outliers (smaller than 0.5\% or
larger than 99.5\% of the other precise observations).}

\item{rounding_degrees}{A numeric vector with the presumed rounding degrees for Y.}
}
\value{
An integer equal to the (sum of the) negative log-likelihood contributions (of the observations)
}
\description{
This function based on Drechsler, Kiesl & Speidel (2015)
is needed in the imputation routine for rounded income.
It calculates the likelihood contribution of the data
(regardless whether they are observed precisely or presumably rounded).
}
\references{
Joerg Drechsler, Hans Kiesl, Matthias Speidel (2015):
"MI Double Feature: Multiple Imputation to Address Nonresponse and Rounding Errors in Income Questions",
Austrian Journal of Statistics, Vol. 44, No. 2, \url{http://dx.doi.org/10.17713/ajs.v44i2.77}
}
