% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelbuilding.R
\name{bimodal_emulator_from_data}
\alias{bimodal_emulator_from_data}
\title{Bimodal Emulation}
\usage{
bimodal_emulator_from_data(
  data,
  output_names,
  ranges,
  input_names = names(ranges),
  verbose = interactive(),
  ...
)
}
\arguments{
\item{data}{The data to train emulators on (as in variance_emulator_from_data)}

\item{output_names}{The names of the outputs to emulate}

\item{ranges}{The parameter ranges}

\item{input_names}{The names of the parameters (by default inferred from \code{ranges})}

\item{verbose}{Should status updates be provided?}

\item{...}{Any other parameters to pass to emulator training}
}
\value{
A list \code{(mode1, mode2, prop)} of emulator lists and objects.
}
\description{
Performs emulation of bimodal outputs and/or systems.
}
\details{
In many stochastic systems, particularly disease models, the outputs exhibit bimodality - a
familiar example is where a disease either takes off or dies out. In these cases, it is not
sensible to emulate the outputs based on all realisations, and instead we should emulate each
mode separately.

This function first tries to identify bimodality. If detected, it determines which of the
outputs in the data exhibits the bimodality: to these two separate emulators are trained, one
to each mode. The emulators are provided with any data that is relevant to their training; for
example, bimodality can exist in some regions of parameter space but not others. Points where
bimodality is present have their realisations allocated between the two modes while points
where no bimodality exists have their realisations provided to both modes. Targets that do not
exhibit bimodality are trained as a normal stochastic output: that is, using the default of
\code{\link{variance_emulator_from_data}}.

The function also estimates the proportion of realisations in each mode for the set of outputs.
This value is also emulated as a deterministic emulator and included in the output.

The output of the function is a list, containing three objects: \code{mode1}, \code{mode2}, and
\code{prop}. The first two objects have the form produced by \code{variance_emulator_from_data}
while \code{prop} has the form of an \code{emulator_from_data} output.
}
\examples{
 \donttest{
  # Use the stochastic SIR dataset
  SIR_ranges <- list(aSI = c(0.1, 0.8), aIR = c(0, 0.5), aSR = c(0, 0.05))
  SIR_names <- c("I10", "I25", "I50", "R10", "R25", "R50")
  b_ems <- bimodal_emulator_from_data(SIR_stochastic$training, SIR_names, SIR_ranges)
 }

}
