% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosticplots.R
\name{validation_pairs}
\alias{validation_pairs}
\title{Validation Set Diagnostics and Implausibility}
\usage{
validation_pairs(ems, points, targets, ranges, nth = 1, cb = FALSE)
}
\arguments{
\item{ems}{The \code{\link{Emulator}} object(s).}

\item{points}{The set of validation points to plot.}

\item{targets}{The set of targets to match to.}

\item{ranges}{If provided, this gives the plotting region (see above).}

\item{nth}{The level of maximum implausibility to plot.}

\item{cb}{Whether or not the colour scheme should be colourblind friendly.}
}
\value{
A ggplot object.
}
\description{
Creates pairs plots on the set of validation points of diagnostic suitability and
implausibility.
}
\details{
The plots are organised as follows:

a) Emulated versus simulated output (lower diagonal). This is similar in spirit to
\code{\link{comparison_diag}}: the plotted points are their location in the input
space and the points are coloured by the emulator prediction's deviation from the
simulator value.

b) Implausibility (upper diagonal). The points are again plotted based on their
location in input space, but their colouration is now based on the implausibility
of the point.

If \code{ranges} is provided, then the plotting region is created relative to these
ranges. This can be useful if on later waves of a history match and the plotting is
to be done relative to the original input space, rather than the (reduced) parameter
space upon which the emulators have been trained.
}
\examples{
 validation_pairs(SIREmulators$ems, SIRSample$validation, SIREmulators$targets)
 wider_ranges <- purrr::map(SIREmulators$ems[[1]]$ranges, ~.*c(-2, 2))
 validation_pairs(SIREmulators$ems, SIRSample$validation,
  SIREmulators$targets, ranges = wider_ranges, cb = TRUE)
}
\seealso{
Other visualisation tools: 
\code{\link{behaviour_plot}()},
\code{\link{diagnostic_wrap}()},
\code{\link{effect_strength}()},
\code{\link{emulator_plot}()},
\code{\link{output_plot}()},
\code{\link{plot_actives}()},
\code{\link{plot_lattice}()},
\code{\link{plot_wrap}()},
\code{\link{simulator_plot}()},
\code{\link{space_removed}()},
\code{\link{wave_dependencies}()},
\code{\link{wave_points}()},
\code{\link{wave_values}()}
}
\concept{visualisation tools}
