% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hit.R
\name{samp1.lasso}
\alias{samp1.lasso}
\title{Variabel Screening}
\usage{
samp1.lasso(samp1, x, y, family, penalty.factor, sel.method, act.freq, nfolds,
  lambda.opt, n.samp2, ...)
}
\arguments{
\item{samp1}{List of index for subsample (mclapply index).}

\item{x}{Design matrix, of dimension n x p.}

\item{y}{Vector of quantitative response variable.}

\item{family}{Distribution family of \code{y}.}

\item{penalty.factor}{See glmnet.}

\item{sel.method}{Name of method for the selection of covariates via the 
LASSO, either "AF" (default), the occurrence frequenze of covariates along 
the lambda path or "CV" n-fold cross-validation.}

\item{act.freq}{Frequency in which a covariate has to occur along the 
lambda path to be selected in the active set. Ignored if \code{sel.method} 
is "CV".}

\item{nfolds}{Number of folds (default is 10). Ignored if \code{sel.method} 
is "ASF". See \code{\link[glmnet]{cv.glmnet}} for more details.}

\item{lambda.opt}{Criterion for optimum selection of cross validated lasso. 
Either "lambda.1se" (default) or "lambda.min". Ignored if \code{sel.method} 
is "ASF". See \code{\link[glmnet]{cv.glmnet}} for more details.}

\item{n.samp2}{Number of individuals in samp2 which is the max. 
for non zero coefficients.}

\item{...}{Additional agruments}
}
\description{
LASSO function of the HIT algorithem.
}
\keyword{internal}

