% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realizedMeasures.R
\name{rOWCov}
\alias{rOWCov}
\title{Realized outlyingness weighted covariance}
\usage{
rOWCov(
  rData,
  cor = FALSE,
  alignBy = NULL,
  alignPeriod = NULL,
  makeReturns = FALSE,
  seasadjR = NULL,
  wFunction = "HR",
  alphaMCD = 0.75,
  alpha = 0.001,
  ...
)
}
\arguments{
\item{rData}{a \eqn{(M x N)} \code{xts} object containing the \eqn{N}
return series over period \eqn{t}, with \eqn{M} observations during \eqn{t}.}

\item{cor}{boolean, in case it is \code{TRUE}, and the input data is multivariate, the correlation is returned instead of the covariance matrix. 
\code{FALSE} by default.}

\item{alignBy}{character, indicating the time scale in which \code{alignPeriod} is expressed. 
Possible values are: \code{"ticks"}, \code{"secs"}, \code{"seconds"}, \code{"mins"}, \code{"minutes"}, \code{"hours"}}

\item{alignPeriod}{positive numeric, indicating the number of periods to aggregate over. For example, to aggregate
based on a 5-minute frequency, set \code{alignPeriod = 5} and \code{alignBy = "minutes"}.}

\item{makeReturns}{boolean, should be \code{TRUE} when \code{rData} contains prices instead of returns. \code{FALSE} by default.}

\item{seasadjR}{a \eqn{(M x N)} \code{xts} object containing
the seasonally adjusted returns. This is an optional argument.}

\item{wFunction}{determines whether
a zero-one weight function (one if no jump is detected based on \eqn{d_{t,i}} and 0 otherwise)
or
Soft Rejection ("SR") weight function is to be used.
By default a zero-one weight function (wFunction = "HR") is used.}

\item{alphaMCD}{a numeric parameter, controlling the size of
the subsets over which the determinant is minimized.
Allowed values are between 0.5 and 1 and
the default is 0.75. See Boudt et al. (2008) or the \code{covMcd} function in the
\pkg{\link[robustbase:covMcd]{robustbase}} package.}

\item{alpha}{is a parameter between 0 and 0.5,
that determines the rejection threshold value
(see Boudt et al. (2008) for details).}

\item{...}{used internally, do not change.}
}
\value{
an \eqn{N \times N} matrix
}
\description{
Calculate the Realized Outlyingness Weighted Covariance (rOWCov), defined in Boudt et al. (2008).

Let \eqn{r_{t,i}}, for \eqn{i = 1,..., M} be a sample
of \eqn{M} high-frequency \eqn{(N \times 1)} return vectors and \eqn{d_{t,i}}
their outlyingness given by the squared Mahalanobis distance between
the return vector and zero in terms of the reweighted MCD covariance
estimate based on these returns.

Then, the rOWCov is given by
\deqn{
\mbox{rOWCov}_{t}=c_{w}\frac{\sum_{i=1}^{M}w(d_{t,i})r_{t,i}r'_{t,i}}{\frac{1}{M}\sum_{i=1}^{M}w(d_{t,i})},
}
The weight  \eqn{w_{i,\Delta}} is one if the multivariate jump test statistic for \eqn{r_{i,\Delta}} in Boudt et al. (2008) is less
than the 99.9\% percentile of the chi-square distribution with \eqn{N} degrees of freedom and zero otherwise.
The scalar \eqn{c_{w}} is a correction factor ensuring consistency of the rOWCov for the Integrated Covariance,
under the Brownian Semimartingale with Finite Activity Jumps model.
}
\details{
Advantages of the rOWCov compared to the \code{\link{rBPCov}} include a higher statistical efficiency, positive semi-definiteness and affine equi-variance.
However, the rOWCov suffers from a curse of dimensionality.
The rOWCov gives a zero weight to a return vector
if at least one of the components is affected by a jump.
In the case of independent jump occurrences, the average proportion of observations
with at least one component being affected by jumps increases fast with the dimension
of the series. This means that a potentially large proportion of the returns receives
a zero weight, due to which the rOWCov can have a low finite sample efficiency in higher dimensions.
}
\examples{
\dontrun{
library("xts")
# Realized Outlyingness Weighted Variance/Covariance for prices aligned
# at 1 minutes.

# Univariate:
row <- rOWCov(rData = as.xts(sampleOneMinuteData[as.Date(DT) == "2001-08-04",
                                                 list(DT, MARKET)]), makeReturns = TRUE)
row

# Multivariate:
rowc <- rOWCov(rData = as.xts(sampleOneMinuteData[as.Date(DT) == "2001-08-04",]),
               makeReturns = TRUE)
rowc
}
}
\references{
Boudt, K., Croux, C., and Laurent, S. (2008). Outlyingness weighted covariation. \emph{Journal of Financial Econometrics}, 9, 657–684.
}
\seealso{
\code{\link{ICov}} for a list of implemented estimators of the integrated covariance.
}
\author{
Jonathan Cornelissen, Kris Boudt, and Emil Sjoerup.
}
\keyword{volatility}
