% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highcharts-api.R
\name{hc_annotations}
\alias{hc_annotations}
\title{Annotations options for highcharter objects}
\usage{
hc_annotations(hc, ...)
}
\arguments{
\item{hc}{A \code{highchart} \code{htmlwidget} object.}

\item{...}{Arguments defined in \url{https://api.highcharts.com/highcharts/annotations}.}
}
\description{
A basic type of an annotation. It allows to add custom labels
or shapes. The items  can be tied to points, axis coordinates
or chart pixel coordinates.
}
\examples{

# Ex 1
highchart() \%>\% 
  hc_add_series(
    data = c(29.9, 71.5, 106.4, 129.2, 144.0, 176.0, 135.6, 148.5, 216.4, 194.1, 95.6, 54.4)
  ) \%>\% 
  hc_xAxis(
    tickInterval = 0.5,
    gridLineWidth = 1  
  ) \%>\% 
  hc_annotations(
    list(
      labels = 
        list(
          list(
            point = list(x = 3, y = 129.2, xAxis = 0, yAxis = 0),
            text = "x: {x}<br/>y: {y}"
            ),
          list(
            point = list(x = 9, y = 194.1, xAxis = 0, yAxis = 0),
            text = "x: {x}<br/>y: {y}"
            ),
          list(
            point = list(x = 5, y = 100, xAxis = 0),
            text = "x: {x}<br/>y: {point.plotY} px"
            ),
          list(
            point = list(x = 0, y = 0),
            text = "x: {point.plotX} px<br/>y: {point.plotY} px"
            )
          )
      )
    )
  
# Ex 2
df <- data.frame(
  x = 1:10,
  y = 1:10
)

highchart() \%>\% 
  hc_add_series(data = df, hcaes(x = x, y = y), type = "area") \%>\% 
  hc_annotations(
    list(
      labels = list(
        list(point = list(x = 5, y = 5, xAxis = 0, yAxis = 0), text = "Middle"),
        list(point = list(x = 1, y = 1, xAxis = 0, yAxis = 0), text = "Start")
      )
    )
  )

}
