% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/hierband.cv.R
\name{hierband.cv}
\alias{hierband.cv}
\title{Performs nfolds-cross validation}
\usage{
hierband.cv(pathObj, x, errfun = function(est, true) sum((est - true)^2),
  nfolds = 5)
}
\arguments{
\item{pathObj}{output of hierband.path}

\item{x}{\code{n} by \code{p} matrix}

\item{errfun}{a user-specified function measuring the loss incurred by estimating \code{est} (first argument)
when the true covariance matrix is \code{true} (second argument).  Default: Squared Frobenius norm.}

\item{nfolds}{number of folds (default: 5)}
}
\value{
\describe{
\item{errs: }{A \code{nlam}-by-\code{nfolds} matrix of errors.  \code{errs[i,j]} is error incurred in using \code{lamlist[i]} on fold \code{j}}
\item{m: }{CV error error for each value of lambda.}
\item{se: }{Standard error (estimated over folds) for each value of lambda}
\item{lam.best: }{Value of \code{lamlist} minimizing CV error.}
\item{ibest: }{Index of \code{lamlist} minimizing CV error.}
\item{lam.1se.rule: }{Selected value of lambda using the one-standard-error rule, a common heuristic that favors a sparser model when there isn't strong evidence against it.}
\item{i.1se.rule: }{Index of \code{lamlist} of one-standard-error rule.}
}
}
\description{
This function can be used to select a value of lam that performs well according to a user-specified measure of error.
}
\examples{
set.seed(123)
p <- 100
n <- 50
K <- 10
true <- ma(p, K)
x <- matrix(rnorm(n*p), n, p) \%*\% true$A
Sighat <- cov(x)
path <- hierband.path(Sighat)
cv <- hierband.cv(path, x)
fit <- hierband(Sighat, lam=cv$lam.best)
\dontrun{
plot(cv$m, main="CV Frob Error", type="b")
lines(cv$m+cv$se, main="CV Frob Error")
lines(cv$m-cv$se, main="CV Frob Error")
abline(v=c(cv$ibest,cv$i.1se.rule), lty=2)
}
}
\seealso{
\code{\link{hierband}} \code{\link{hierband.path}}
}

