% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_helpers.R
\name{cell_to_lonlat}
\alias{cell_to_lonlat}
\title{Convert cell ID to longitude/latitude}
\usage{
cell_to_lonlat(cell_id, grid)
}
\arguments{
\item{cell_id}{Numeric vector of cell IDs}

\item{grid}{A HexGridInfo or HexData object}
}
\value{
Data frame with lon_deg and lat_deg columns
}
\description{
Converts DGGS cell IDs back to geographic coordinates (cell centers).
}
\examples{
grid <- hex_grid(area_km2 = 1000)
cells <- lonlat_to_cell(c(0, 10), c(45, 50), grid)
coords <- cell_to_lonlat(cells, grid)
}
\seealso{
\code{\link{lonlat_to_cell}} for the forward operation
}
