% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heuristics.R
\name{singleCueModel}
\alias{singleCueModel}
\title{Single Cue Model}
\usage{
singleCueModel(train_data, criterion_col, cols_to_fit,
  reverse_cues = TRUE, fit_name = "singleCueModel")
}
\arguments{
\item{train_data}{Training/fitting data as a matrix or data.frame.}

\item{criterion_col}{The index of the colum in train_data that has the
criterion.}

\item{cols_to_fit}{A vector of column indices in train_data, used to fit
the criterion.}

\item{reverse_cues}{Optional parameter to reverse cues as needed.  By
default, the model will reverse the cue values for cues with cue validity
< 0.5, so a cue with validity 0 becomes a cue with validity 1.
Set this to FALSE if you do not want that, i.e. the cue stays validity 0.}

\item{fit_name}{Optional The name other functions can use to label output.
It defaults to the class name.}
}
\description{
Create a single cue model by specifying columns and a dataset.  It sorts
cues in order of cueValidity and uses the cue with the highest cueValidity.
If the cue does not discriminate it guesses randomly.  If several cues have
the highest validity, then on each prediction it randomly selects which one
to use (so it might not give the same answer every time).
}
\details{
This single cue model follows the definition used in this reference:
Hogarth, R. & Karelaia, N. (2007). Heuristic and Linear Models of Judgment: 
Matching Rules and Environments. Psychological Review. 114(3), pp.733-758.
Note that other researchers have sometimes used other measures than cue
validity to select the single cue to be used.
}
\examples{
##Fit column (5,4) to column (1,0), having validity 1.0, and column (0,1),
## validity 0.
train_matrix <- cbind(y=c(5,4), x1=c(1,0), x2=c(0,1))
singlecue <- singleCueModel(train_matrix, 1, c(2,3))
predictPair(oneRow(train_matrix, 1), oneRow(train_matrix, 2), singlecue)

}
\seealso{
\code{\link{predictPairProb}} for prediction.
}
