% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_systematic.R
\name{R2}
\alias{R2}
\title{Estimate treatment variation R2}
\usage{
R2(est.beta, rho.step)
}
\arguments{
\item{est.beta}{The output from `est.beta()`. Either an estimate of overall
systematic effect variation, or systematic effect variation for compliers.}

\item{rho.step}{Grid size for sensitivity analysis on values of rho. Default
is 0.05}
}
\value{
RI.R2.result object.
}
\description{
Bounds the R2 measure (how much of treatment variation is explained by given
covariates) using either the OLS output for the ITT from est.beta, or the
LATE estimation from est.beta.
}
\examples{
df <- make.randomized.dat( 1000, gamma.vec=c(1,1,1,2), beta.vec=c(-1,-1,1,0) )
es <- estimate_systematic( Yobs ~ Z,  interaction.formula = ~ A + B, data = df )
r2_out <- R2(es)

}
\seealso{
print.RI.R2.result
}
