% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crnGP.R
\name{predict.CRNGP}
\alias{predict.CRNGP}
\title{Gaussian process predictions using a GP object for correlated noise (of class \code{CRNGP})}
\usage{
\method{predict}{CRNGP}(object, x, xprime = NULL, t0 = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{CRNGP}; e.g., as returned by \code{\link[hetGP]{mleCRNGP}}}

\item{x}{matrix of designs locations to predict at (one point per row). Last column is for the integer valued seed. 
If trajectories are considered, i.e., with time, the prediction will occur at the same times as the training data unless \code{t0} is provided.}

\item{xprime}{optional second matrix of predictive locations to obtain the predictive covariance matrix between \code{x} and \code{xprime}}

\item{t0}{single column matrix of times to predict at, if trajectories are considered. By default the prediction is at the same times as the training data.}

\item{...}{no other argument for this method}
}
\value{
list with elements
\itemize{
\item \code{mean}: kriging mean;
\item \code{sd2}: kriging variance (filtered, e.g. without the nugget value)
\item \code{cov}: predictive covariance matrix between \code{x} and \code{xprime}
\item \code{nugs}: nugget value at each prediction location, for consistency with \code{\link[hetGP]{mleHomGP}}.
}
}
\description{
Gaussian process predictions using a GP object for correlated noise (of class \code{CRNGP})
}
\details{
The full predictive variance corresponds to the sum of \code{sd2} and \code{nugs}. See \code{\link[hetGP]{mleHomGP}} for examples.
}
