% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contour.R
\name{crit_tMSE}
\alias{crit_tMSE}
\title{t-MSE criterion}
\usage{
crit_tMSE(x, model, thres = 0, preds = NULL, seps = 0.05)
}
\arguments{
\item{x}{matrix of new designs, one point per row (size n x d)}

\item{model}{\code{homGP} or \code{hetGP} model, including inverse matrices}

\item{thres}{for contour finding}

\item{preds}{optional predictions at \code{x} to avoid recomputing if already done (must contain \code{cov})}

\item{seps}{parameter for the target window}
}
\description{
Computes targeted mean squared error infill criterion
}
\examples{
## Infill criterion example
set.seed(42)
branin <- function(x){
  m <- 54.8104; s <- 51.9496
  if(is.null(dim(x))) x <- matrix(x, nrow = 1)
  xx <- 15 * x[,1] - 5; y <- 15 * x[,2]
  f <- (y - 5.1 * xx^2/(4 * pi^2) + 5 * xx/pi - 6)^2 + 10 * (1 - 1/(8 * pi)) * cos(xx) + 10
  f <- (f - m)/s
  return(f)
}

ftest <- function(x, sd = 0.1){
  if(is.null(dim(x))) x <- matrix(x, nrow = 1)
  return(apply(x, 1, branin) + rnorm(nrow(x), sd = sd))
}

ngrid <- 101; xgrid <- seq(0, 1, length.out = ngrid)
Xgrid <- as.matrix(expand.grid(xgrid, xgrid))
Zgrid <- ftest(Xgrid)

n <- 20
N <- 500
X <- Xgrid[sample(1:nrow(Xgrid), n),]
X <- X[sample(1:n, N, replace = TRUE),]
Z <- ftest(X)
model <- mleHetGP(X, Z, lower = rep(0.001,2), upper = rep(1,2))

critgrid <- apply(Xgrid, 1, crit_tMSE, model = model)

filled.contour(matrix(critgrid, ngrid), color.palette = terrain.colors, main = "tMSE criterion")

}
\references{
Picheny, V., Ginsbourger, D., Roustant, O., Haftka, R., Kim, N. (2010).
Adaptive designs of experiments for accurate approximation of a target region,
Journal of Mechanical Design (132), p. 071008.\cr \cr

Lyu, X., Binois, M. & Ludkovski, M. (2018). 
Evaluating Gaussian Process Metamodels and Sequential Designs for Noisy Level Set Estimation. arXiv:1807.06712. \cr
}
