% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_ceaf}
\alias{plot_ceaf}
\title{Plot cost-effectiveness acceptability frontier}
\usage{
plot_ceaf(x, labels = NULL)
}
\arguments{
\item{x}{A \code{cea} object produced by \code{\link{cea}}.}

\item{labels}{A list of named vectors containing the values and labels of
variables. The elements of each vector are the values of a variable and the
names are the labels. The names of the list are the names of the variables.
See the output returned by \code{\link[=get_labels]{get_labels()}} for an example.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot a cost-effectiveness acceptability frontier (CEAF) from the output of
\code{\link{cea}} using \code{\link[ggplot2:ggplot]{ggplot2::ggplot}}. The CEAF plots the probability
that the optimal treatment strategy (i.e., the strategy with the highest
expected net monetary benefit) is cost-effective.
}
\details{
See the \code{\link[=cea]{cea()}} documentation for an example. If there are multiple subgroups,
then a faceted plot is produced with one plot for each subgroup.
}
