% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_def.R
\name{rng_distributions}
\alias{rng_distributions}
\alias{beta_rng}
\alias{dirichlet_rng}
\alias{fixed}
\alias{custom}
\alias{gamma_rng}
\alias{lognormal_rng}
\alias{multi_normal_rng}
\alias{normal_rng}
\alias{uniform_rng}
\title{Random number generation distributions}
\usage{
beta_rng(shape1 = 1, shape2 = 1, mean = NULL, sd = NULL, names = NULL)

dirichlet_rng(alpha, names = NULL)

fixed(est, names = NULL)

custom(x, names = NULL)

gamma_rng(mean, sd, names = NULL)

lognormal_rng(meanlog, sdlog, names = NULL)

multi_normal_rng(mu, Sigma, names = NULL, ...)

normal_rng(mean, sd, names = NULL)

uniform_rng(min, max, names = NULL)
}
\arguments{
\item{shape1, shape2}{Non-negative parameters of the Beta distribution.}

\item{mean, sd}{Mean and standard deviation of the random variable.}

\item{names}{Names for columns if an object with multiple columns is returned
by the function.}

\item{alpha}{A matrix where each row is a separate vector of shape parameters.}

\item{est}{A vector of estimates of the variable of interest.}

\item{x}{A numeric \code{vector}, \code{matrix}, \code{data.frame}, or \code{data.table} containing
random samples of the variable of interest from a suitable probability distribution. This would
typically be a posterior distribution from a Bayesian analysis.}

\item{meanlog, sdlog}{Mean and standard deviation of the distribution on the
log scale.}

\item{mu, Sigma}{\code{mu} is a vector giving the means of the variables and
\code{Sigma} is a positive-definite symmetric matrix specifying the
covariance matrix of the variables.}

\item{...}{Additional arguments to pass to underlying random number generation
functions. See "details".}

\item{min, max}{Lower and upper limits of the distribution. Must be finite.}
}
\value{
Functions either return a vector of length \code{n} or an \code{n} by \code{k} \code{data.table}.
Multivariate distributions always return a \code{data.table}. If a
univariate distribution is used, then a \code{data.table} is returned if each
parameter is specified as a vector with length greater than 1; otherwise, if
parameters are scalars, then a vector is returned. In the \code{data.table} case,
\code{k} is equal to the length of the parameter vectors
entered as  arguments. For example, if the probability distribution contained
\code{mean} as an argument and \code{mean} were
of length 3, then an \code{n} by 3 matrix would be returned. The length of all
parameter vectors must be the same. For instance, if the vector \code{mean}
were of length 3 then all additional parameters (e.g., \code{sd})
must also be of length 3.

If a \code{data.table} is returned by a distribution, then its column names are set
according to the following hierarchy:
\enumerate{
\item With the \code{names} argument if it is not \code{NULL}
\item With the names of the parameter vectors if they are named vectors. If there
are multiple parameter vector arguments, then the names of the first parameter
vector with non \code{NULL} names is used. For instance, if \code{mean} and \code{sd} are
both arguments to a random number generation function and \code{mean} is a
named vector, then the names from the vector \code{mean} are used.
\item As \code{v1}, ..., \code{vk} if the \code{names} argument is \code{NULL} and there are no
named parameter vectors.
}
}
\description{
A collection of functions for randomly generating deviates from probability
distributions with \code{\link[=define_rng]{define_rng()}}.
}
\details{
These functions are not exported and are meant for use with
\code{\link[=define_rng]{define_rng()}}. They consequently assume that the number of samples to draw, \code{n},
is defined in the parent environment. Convenience random number generation
functions include:
\describe{
\item{\code{beta_rng()}}{If \code{mean} and \code{sd} are both not \code{NULL}, then
parameters of the beta distribution are derived using
the methods of moments with \code{\link[=mom_beta]{mom_beta()}}. Beta variates are generated with
\code{\link[stats:rbeta]{stats::rbeta()}}.}
\item{\code{custom()}}{Use previously sampled values from a custom probability distribution.
There are three possibilities: (i) if \code{n} is equal to the number previously
sampled values (say \code{n_samples}), then \code{x} is returned as is; (ii) if
\code{n} < \code{n_samples}, then samples from \code{x} are sampled without replacement;
and (iii) if \code{n} > \code{n_samples}, then samples from \code{x} are sampled with replacement
and a warning is provided.}
\item{\code{dirichlet_rng()}}{Dirichlet variates for each row in the matrix are
generated with \code{\link[=rdirichlet_mat]{rdirichlet_mat()}}. The sampled values are stored in a \code{data.table}
where there is a column for each element of \code{alpha}
(with elements ordered rowwise).}
\item{\code{fixed()}}{This function should be used when values of the variable
of interest are fixed (i.e., they are known with certainty). If \code{length(est) > 1},
an \code{n} by \code{length(est)} \code{data.table} is returned meaning that each element of \code{est}
is repeated \code{n} times; otherwise (if \code{length(est) == 1}), a vector is returned
where \code{est} is repeated \code{n} times.}
\item{\code{gamma_rng()}}{The parameters of the gamma distribution are derived using
the methods of moments with \code{\link[=mom_gamma]{mom_gamma()}} and gamma variates are generated
with \code{\link[stats:rgamma]{stats::rgamma()}}.}
\item{\code{lognormal_rng()}}{Lognormal variates are generated with \code{\link[stats:rlnorm]{stats::rlnorm()}}.}
\item{\code{multi_normal_rng()}}{Multivariate normal variates are generated with \code{\link[MASS:mvrnorm]{MASS::mvrnorm()}}.}
\item{\code{normal_rng()}}{Normal variates are generated with \code{\link[stats:rnorm]{stats::rnorm()}}.}
\item{\code{uniform_rng()}}{Uniform variates are generated with \code{\link[stats:runif]{stats::runif()}}.}

}
}
\seealso{
\code{\link[=define_rng]{define_rng()}}
}
