% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-fits.R
\name{joined}
\alias{joined}
\alias{joined_formula}
\alias{joined_formula_list}
\alias{joined_flexsurvreg}
\alias{joined_flexsurvreg_list}
\title{Join statistical models at specified times}
\usage{
joined_formula(..., times)

joined_formula_list(..., times)

joined_flexsurvreg(..., times)

joined_flexsurvreg_list(..., times)
}
\arguments{
\item{...}{Model objects to join. Currently supports objects of class
\code{\link{formula}}, \code{\link{formula_list}}, \code{\link{flexsurvreg}}, and
\code{\link{flexsurvreg_list}}.}

\item{times}{Times at which to join models. If joining a single set of models, then a sorted
numeric vector of times. If joining multiple sets of models, then a list of sorted numeric vectors,
with the length of each list element equal to the number of sets of models.}
}
\value{
Returns a class of the same name as the function that is a
list with two variables:
\describe{
\item{models}{List of joined models.}
\item{times}{Time points to join models.}
}
}
\description{
Construct classes which are used to join statistical models at specified time points.
The first model is used prior to the first time point, the second
model is used prior to the second time point, and so on. There should be \code{N + 1}
models and \code{N} time points. Can be used to join a single set of models (e.g., for survival analysis or for making predictions from a jointly
estimated multi-state model) or to join multiple sets of models (e.g., predicting curves in a
partitioned survival analysis).
}
\examples{
# joined_formula
joined_fm <- joined_formula(f1 = formula(~ age), f2 = formula(~ 1),
                                 f3 = formula(~age + age2),
                                 times = c(2, 3))
print(joined_fm)
 
# joined_formula_list
fm_list1 <- formula_list(f1 = formula(~ age), f2 = formula(~ 1))
fm_list2 <- formula_list(f1 = formula(~ age), f2 = formula(~ age2), f3 = formula(~age3))
joined_fm_list <- joined_formula_list(model1 = fm_list1, model2 = fm_list2, 
                                     times = list(5, c(2, 4)))
class(joined_fm_list)                                             
                                            
# joined_flexsurvreg
library("flexsurv")
fit_wei <- flexsurv::flexsurvreg(formula = Surv(futime, fustat) ~ 1, 
                                data = ovarian, dist = "weibull")
fit_exp <- flexsurv::flexsurvreg(formula = Surv(futime, fustat) ~ 1, 
                                 data = ovarian, dist = "exp")
joined_fsr <- joined_flexsurvreg(fit_wei, fit_exp, times = 5)
class(joined_fsr)
}
\keyword{internal}
