\name{gof}

\alias{gof}

\alias{gof.hergm}

\alias{hergm.gof}

\title{Goodness-of-fit}

\description{

The function \code{gof.hergm} assesses the goodness-of-fit of the model by generating posterior predictions based on a MCMC sample generated by function \code{hergm}.

}

\usage{

\method{gof}{hergm}(sample = NULL,
          \dots)

}

\arguments{

\item{sample}{MCMC sample generated by function \code{hergm}.}

\item{\dots}{additional arguments, to be passed to lower-level functions in the future.}

}

\value{

\item{component.number}{number of components.}

\item{max.component.size}{size of largest component.}

\item{distance}{geodesic distance of pairs of nodes.}

\item{degree}{degree of nodes.}

\item{edges}{number of edges.}

\item{stars}{number of \code{2}-stars.}

\item{triangle}{number of triangles.}

}

\seealso{network, hergm}

\examples{
\dontrun{
data(example)

sample <- hergm(d ~ edges_ij + triangle_ijk)

gof.hergm(sample)
}
}

